# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from enum import Enum
from .apiexception import APIException

class SDApiError(Enum):
    """
    Enum representing error code from an API call
    """
    """API Call succeed"""
    NoError = 0
    """API Call succeed but the output parameter has not been set"""
    NoErrorOutputParamNotSet = 1
    """Undefined error"""
    Undefined = 2
    """One or more of the specified arguments were invalid"""
    InvalidArgument = 3
    """Insufficient memory"""
    MemoryAllocationFailed = 4
    """The specified index is out of bounds of the container"""
    IndexOutOfBounds = 5
    """Type conversion failed"""
    TypeConversionFailed = 6
    """Unable to write on device (Possible reasons: device is readonly; the path does not exist; insufficient access rights, ..."""
    WriteToDeviceFailed = 7
    """Substance Engine is invalid or can't be found"""
    InvalidSubstanceEngine = 8
    """The handle is invalid"""
    InvalidHandle = 9
    """The specified type is invalid"""
    InvalidType = 10
    """The specified value is invalid"""
    InvalidValue = 11
    """Not yet implemented"""
    NotImplemented = 12
    """The operation is not supported by the object"""
    NotSupported = 13
    """The specified item cannot be found"""
    ItemNotFound = 14
    """The data is readonly"""
    DataIsReadOnly = 15
    """The Iray SDK data is not initialized properly (possible reasons: not supported by current platform; missing library; ...)"""
    IrayNotInitialized = 16
    """The data is function readonly. his value is only controlled by a function. No getValue/setValue is allowed"""
    DataIsFunctionOnly = 17
    """Unable to read from device"""
    ReadFromDeviceFailed = 18
    """The package has not been saved already"""
    PackageNotSaved = 19

class SDAPIObject:
    """
    Base class for all APIObjects
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDAPIObject
        """
        self.mAPIContext = APIContext
        self.mHandle = handle
        self.ownHandle = kwargs['ownHandle'] if 'ownHandle' in kwargs else True

    def release(self) -> None:
        """
        Releases an APIObject

        """
        _res = self.mAPIContext.SDAPIObject_release(self.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        self.mHandle = None
        return None

    def getClassName(self) -> str:
        """
        Returns the most specific name of the class this APIObject is

        """
        outClassName = ctypes.c_char_p()
        _res = self.mAPIContext.SDAPIObject_getClassName(self.mHandle, ctypes.byref(outClassName))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outClassName.value.decode('utf-8') # type: ignore
    def __del__(self):
        if self.ownHandle and self.mHandle:
            self.release()
    def __enter__(self):
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        if self.ownHandle and self.mHandle:
            self.release()

